# Employee QR Code Attendance System

A complete web-based employee attendance system using QR codes, built with PHP, MySQL, HTML, CSS, and Vanilla JavaScript.

## Features

- **Admin Side**
  - Secure admin authentication with password hashing
  - Create and manage employees
  - Generate unique QR codes for each employee
  - Download QR codes as images

- **Employee Side**
  - Access attendance via QR code scan
  - Check-in and check-out functionality
  - Server-side validation to prevent duplicate entries
  - Clear success/error messages

## Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache web server with mod_rewrite
- GD library (for QR code generation - optional, uses external service as fallback)

## Installation

### 1. Database Setup

1. Access your MySQL database via phpMyAdmin or command line
2. Import the `database.sql` file:
   ```sql
   mysql -u your_username -p your_database < database.sql
   ```
   Or use phpMyAdmin's Import feature

3. **IMPORTANT**: Change the default admin password:
   - Default email: `admin@example.com`
   - Default password: `admin123`
   - Use PHP to generate a new hash:
     ```php
     <?php echo password_hash('your_new_password', PASSWORD_DEFAULT); ?>
     ```
   - Update the `admins` table with the new hash

### 2. Configuration

1. Open `config/db.php` and update database credentials:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'employee_attendance');
   define('DB_USER', 'your_database_user');
   define('DB_PASS', 'your_database_password');
   ```

2. Update the base URL in `admin/dashboard.php` (line ~12):
   ```php
   $baseUrl = "https://yourdomain.com"; // Change this to your actual domain
   ```

### 3. File Permissions

Ensure proper file permissions:
- Directories: 755
- PHP files: 644
- `.htaccess`: 644

### 4. Upload to Server

Upload all files to your web server's public directory (usually `public_html` or `www`).

## File Structure

```
/
├── config/
│   ├── db.php          # Database configuration
│   ├── auth.php        # Authentication helpers
│   └── qr.php          # QR code generation
├── admin/
│   ├── login.php       # Admin login page
│   ├── dashboard.php   # Admin dashboard
│   └── logout.php      # Logout handler
├── api/
│   ├── login.php       # Login API endpoint
│   ├── create_employee.php  # Create employee API
│   └── attendance.php  # Attendance API
├── attendance.php      # Employee attendance page
├── css/                # Stylesheets
├── assets/             # Images and assets
├── database.sql        # Database schema
└── .htaccess          # Apache configuration
```

## Usage

### Admin Access

1. Navigate to `/admin/login.php`
2. Login with your admin credentials
3. Create employees from the dashboard
4. Download QR codes for each employee

### Employee Attendance

1. Scan the QR code with any QR scanner
2. Select Check-In or Check-Out
3. Submit the form

## Security Features

- Password hashing using PHP's `password_hash()`
- PDO prepared statements (SQL injection prevention)
- Input sanitization
- Session-based authentication
- Token-based employee access (no employee IDs exposed)
- Server-side validation for attendance rules

## Attendance Rules

- An employee can check-in only once per day
- Check-out is only allowed after check-in
- Uses server time (not browser time)
- Prevents duplicate attendance entries

## Troubleshooting

### Database Connection Error
- Verify database credentials in `config/db.php`
- Ensure database exists and user has proper permissions

### QR Codes Not Displaying
- Check internet connection (uses external QR service)
- Verify base URL is correct in `dashboard.php`

### Session Issues
- Ensure PHP sessions are enabled
- Check file permissions on session directory
- Verify `.htaccess` is working

## Production Recommendations

1. **Change Default Admin Password**: Immediately change the default admin password
2. **Use HTTPS**: Enable SSL certificate for secure connections
3. **QR Code Library**: Consider installing a PHP QR code library (like `endroid/qr-code`) for offline QR generation
4. **Error Logging**: Monitor PHP error logs for issues
5. **Backup**: Regularly backup your database
6. **Update Base URL**: Ensure base URL matches your domain

## Support

For issues or questions, check:
- PHP error logs
- Apache error logs
- Browser console for JavaScript errors

## License

This project is provided as-is for educational and commercial use.
